/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.index.ConcurrentApproximatePriorityQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;

final class LockableConcurrentApproximatePriorityQueue<T extends Lock> {
    private final ConcurrentApproximatePriorityQueue<T> queue;
    private final AtomicInteger addAndUnlockCounter = new AtomicInteger();

    LockableConcurrentApproximatePriorityQueue(int concurrency) {
        this.queue = new ConcurrentApproximatePriorityQueue(concurrency);
    }

    LockableConcurrentApproximatePriorityQueue() {
        this.queue = new ConcurrentApproximatePriorityQueue();
    }

    T lockAndPoll() {
        int addAndUnlockCount;
        do {
            addAndUnlockCount = this.addAndUnlockCounter.get();
            Lock entry = this.queue.poll(Lock::tryLock);
            if (entry == null) continue;
            return (T)entry;
        } while (addAndUnlockCount != this.addAndUnlockCounter.get());
        return null;
    }

    boolean remove(Object o) {
        return this.queue.remove(o);
    }

    boolean contains(Object o) {
        return this.queue.contains(o);
    }

    void addAndUnlock(T entry, long weight) {
        this.queue.add(entry, weight);
        entry.unlock();
        this.addAndUnlockCounter.incrementAndGet();
    }
}

